#!/bin/sh

if [ ! -e /bin/vim-cmd ]; then
	VIMCMD="/usr/bin/vim-cmd";
else
	VIMCMD="/bin/vim-cmd";
fi

if [ "${#}" != 3 ]; then
    printf "Usage:\n\t`basename ${0}` [vmdk_full_path] [prefix_name] [postfix_name]\n";
    echo "e.g.:";
    printf "\t${0} /vmfs/volumes/datastore1/sandbox/sandbox.vmx clone_sandbox origin\n";
    exit 1
fi

clone_pure_vm () {

    local src_vmdk="$(echo ${1} | sed 's/\.vmx$/\.vmdk/g')";
    local dst_prefix=${2};
    local dst_postfix=${3};

    local datastore1=${src_vmdk%/*/*};
    local src_prefix=$(basename ${src_vmdk} | sed 's/\.vmdk$//g');
    local src_vmx="${datastore1}/${src_prefix}/${src_prefix}.vmx"
	
	clonedpath="${datastore1}/${dst_prefix}_${dst_postfix}";
	dst_vmdk="${clonedpath}/${dst_prefix}.vmdk";
	dst_vmx="${clonedpath}/${dst_prefix}.vmx";
	
	/bin/mkdir "${clonedpath}";
	vmkfstools -d thin -i "${src_vmdk}" "${dst_vmdk}";
	sleep 3;
	/bin/cp ${src_vmx} ${dst_vmx};
    
    # drop a file to indicate this vm is an original backup by DDA
    [ ! -e "${clonedpath}/ORIGIN" ] && touch "${clonedpath}/ORIGIN"
}

clone_pure_vm ${1} ${2} ${3}
exit 0

